/////////////////////////////////////////////////////////////
// CINEMA SDK : MAIN MODULE																 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

// Starts the plugin registration

#include "c4d.h"

// forward declarations
Bool RegisterSN();
Bool RegisterGradient(void);
Bool RegisterBitmap(void);
Bool RegisterMandelbrot(void);
Bool RegisterSimpleMaterial(void);
Bool RegisterParticleVolume(void);
Bool RegisterMenuTest(void);
Bool RegisterAsyncTest(void);
Bool RegisterActiveObjectDlg();
Bool RegisterListView(void);
Bool RegisterSubDialog(void);
Bool RegisterSpherify(void);
Bool RegisterRoundedTube(void);
Bool RegisterTriangulate(void);
Bool RegisterVPTest(void);
Bool RegisterVPInvertImage(void);
Bool RegisterBlinker(void);
Bool RegisterAtomObject(void);
Bool RegisterCircle(void);
Bool RegisterSTL(void);
Bool RegisterBFF(void);
Bool RegisterLookAtCamera(void);
Bool RegisterGravitation(void);
Bool RegisterThreshold(void);
Bool RegisterSampleMatrix(void);
Bool RegisterPrimitiveTool(void);
Bool RegisterMorphMixer(void);
Bool RegisterVPVisualizeNormals(void);
Bool RegisterVPReconstruct(void);
Bool RegisterExampleDataType(void);
void FreeTriangulate(void);

Bool PluginStart(void)
{
	// shader plugins
	if (!RegisterGradient()) return FALSE;
	if (!RegisterBitmap()) return FALSE;
	if (!RegisterMandelbrot()) return FALSE;
	if (!RegisterSimpleMaterial()) return FALSE;
	if (!RegisterParticleVolume()) return FALSE;

	// menu plugins
	if (!RegisterMenuTest()) return FALSE;
	if (!RegisterAsyncTest()) return FALSE;
	if (!RegisterActiveObjectDlg()) return FALSE;
	if (!RegisterListView()) return FALSE;
	if (!RegisterSubDialog()) return FALSE;

	// filter plugins
	if (!RegisterSTL()) return FALSE;
	if (!RegisterBFF()) return FALSE;

	// object plugins
	if (!RegisterSpherify()) return FALSE;
	if (!RegisterRoundedTube()) return FALSE;
	if (!RegisterGravitation()) return FALSE;
	if (!RegisterAtomObject()) return FALSE;
	if (!RegisterCircle()) return FALSE;
	if (!RegisterTriangulate()) return FALSE;
	if (!RegisterMorphMixer()) return FALSE;

	// tool plugins
	if (!RegisterPrimitiveTool()) return FALSE;

	// animation plugins
	if (!RegisterBlinker()) return FALSE;

	// tag / expression plugins
	if (!RegisterLookAtCamera()) return FALSE;

	// bitmap filter
	if (!RegisterThreshold()) return FALSE;
	if (!RegisterSampleMatrix()) return FALSE;

	// video post filter
	if (!RegisterVPTest()) return FALSE;
	if (!RegisterVPInvertImage()) return FALSE;
	if (!RegisterVPVisualizeNormals()) return FALSE;
	if (!RegisterVPReconstruct()) return FALSE;

	return TRUE;
}

void PluginEnd(void)
{
}

Bool PluginMessage(LONG id, void *data)
{
	//use the following lines to set a plugin priority
	//
	switch (id)
	{
		case C4DPL_INIT_SYS:
			if (!resource.Init()) return FALSE; // don't start plugin without resource
			if (!RegisterExampleDataType()) return FALSE;
			return TRUE;

		case C4DMSG_PRIORITY: 
			return TRUE;
	}

	return FALSE;
}
